<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

/**
 * The "companies" collection of methods.
 * Typical usage is:
 *  <code>
 *   $jobsService = new Google_Service_CloudTalentSolution(...);
 *   $companies = $jobsService->companies;
 *  </code>
 */
class Google_Service_CloudTalentSolution_Resource_ProjectsCompanies extends Google_Service_Resource
{
  /**
   * Creates a new company entity. (companies.create)
   *
   * @param string $parent Required. Resource name of the project under which the
   * company is created. The format is "projects/{project_id}", for example,
   * "projects/api-test-project".
   * @param Google_Service_CloudTalentSolution_CreateCompanyRequest $postBody
   * @param array $optParams Optional parameters.
   * @return Google_Service_CloudTalentSolution_Company
   */
  public function create($parent, Google_Service_CloudTalentSolution_CreateCompanyRequest $postBody, $optParams = array())
  {
    $params = array('parent' => $parent, 'postBody' => $postBody);
    $params = array_merge($params, $optParams);
    return $this->call('create', array($params), "Google_Service_CloudTalentSolution_Company");
  }
  /**
   * Deletes specified company. Prerequisite: The company has no jobs associated
   * with it. (companies.delete)
   *
   * @param string $name Required. The resource name of the company to be deleted.
   * The format is "projects/{project_id}/companies/{company_id}", for example,
   * "projects/api-test-project/companies/foo".
   * @param array $optParams Optional parameters.
   * @return Google_Service_CloudTalentSolution_JobsEmpty
   */
  public function delete($name, $optParams = array())
  {
    $params = array('name' => $name);
    $params = array_merge($params, $optParams);
    return $this->call('delete', array($params), "Google_Service_CloudTalentSolution_JobsEmpty");
  }
  /**
   * Retrieves specified company. (companies.get)
   *
   * @param string $name Required. The resource name of the company to be
   * retrieved. The format is "projects/{project_id}/companies/{company_id}", for
   * example, "projects/api-test-project/companies/foo".
   * @param array $optParams Optional parameters.
   * @return Google_Service_CloudTalentSolution_Company
   */
  public function get($name, $optParams = array())
  {
    $params = array('name' => $name);
    $params = array_merge($params, $optParams);
    return $this->call('get', array($params), "Google_Service_CloudTalentSolution_Company");
  }
  /**
   * Lists all companies associated with the service account.
   * (companies.listProjectsCompanies)
   *
   * @param string $parent Required. Resource name of the project under which the
   * company is created. The format is "projects/{project_id}", for example,
   * "projects/api-test-project".
   * @param array $optParams Optional parameters.
   *
   * @opt_param int pageSize Optional. The maximum number of companies to be
   * returned, at most 100. Default is 100 if a non-positive number is provided.
   * @opt_param string pageToken Optional. The starting indicator from which to
   * return results.
   * @opt_param bool requireOpenJobs Optional. Set to true if the companies
   * requested must have open jobs. Defaults to false. If true, at most page_size
   * of companies are fetched, among which only those with open jobs are returned.
   * @return Google_Service_CloudTalentSolution_ListCompaniesResponse
   */
  public function listProjectsCompanies($parent, $optParams = array())
  {
    $params = array('parent' => $parent);
    $params = array_merge($params, $optParams);
    return $this->call('list', array($params), "Google_Service_CloudTalentSolution_ListCompaniesResponse");
  }
  /**
   * Updates specified company. Company names can't be updated. To update a
   * company name, delete the company and all jobs associated with it, and only
   * then re-create them. (companies.patch)
   *
   * @param string $name Required during company update. The resource name for a
   * company. This is generated by the service when a company is created. The
   * format is "projects/{project_id}/companies/{company_id}", for example,
   * "projects/api-test-project/companies/foo".
   * @param Google_Service_CloudTalentSolution_UpdateCompanyRequest $postBody
   * @param array $optParams Optional parameters.
   * @return Google_Service_CloudTalentSolution_Company
   */
  public function patch($name, Google_Service_CloudTalentSolution_UpdateCompanyRequest $postBody, $optParams = array())
  {
    $params = array('name' => $name, 'postBody' => $postBody);
    $params = array_merge($params, $optParams);
    return $this->call('patch', array($params), "Google_Service_CloudTalentSolution_Company");
  }
}
