<?php $__env->startSection('content'); ?>
<div class="side-title">
    <h3><?php echo e($head ?? ''); ?></h3>
</div>

<div class="border-item">
    <form class="form-row add_form" method="post" action="<?php echo e($action); ?>" enctype="multipart/form-data">
        <?php if($appSlider ?? ''  && $appSlider->id): ?>
            <?php echo method_field('PUT'); ?>
        <?php endif; ?>
        <?php echo csrf_field(); ?>

        <div class="form-group col">
            <label><?php echo e(meta('type', $lang) ?? __('appSliders.type')); ?> </label>
            <select name="type" class="form-control <?php echo e($errors->has('type') ? 'is-invalid' : ''); ?>">
                <option <?php echo e(old('type', $appSlider->type ?? null) == 'image_only' ? 'selected' : ''); ?> value="image_only"><?php echo e(__('appSliders.image_only')); ?></option>
                <option <?php echo e(old('type', $appSlider->type ?? null) == 'image_service' ? 'selected' : ''); ?> value="image_service"><?php echo e(__('appSliders.image_service')); ?></option>
                <option <?php echo e(old('type', $appSlider->type ?? null) == 'image_external_url' ? 'selected' : ''); ?> value="image_external_url"><?php echo e(__('appSliders.image_external_url')); ?></option>
            </select>
        </div>

        <div class="form-group col-lg-6 service_container <?php echo e(($appSlider->service_id ?? null) ? '' : 'd-none'); ?>">
            <label><?php echo e(meta('service_id', $lang) ?? __('appSliders.service_id')); ?> </label>
            <select name="service_id" class="form-control <?php echo e($errors->has('service_id') ? 'is-invalid' : ''); ?>">
                <?php if(count($services)): ?>
                    <option value=""><?php echo e(meta('service_id', $lang) ?? __('appSliders.service_id')); ?></option>
                    <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option <?php echo e(old('service_id', $appSlider->service_id ?? null) == $service->id ? 'selected' : ''); ?> value="<?php echo e($service->id); ?>"><?php echo e($service->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </select>
        </div>

        <div class="form-group url col-lg-12 url_container <?php echo e(($appSlider->url ?? null) ? '' : 'd-none'); ?>">
            <label><?php echo e(meta('url', $lang) ?? __('appSliders.url')); ?> </label>
            <input type="url" class="form-control <?php echo e($errors->has('url') ? 'is-invalid' : ''); ?>" name="url" placeholder="<?php echo e(meta('url', $lang) ?? __('appSliders.url')); ?>" value='<?php echo e(old("url", $appSlider->url ?? null)); ?>'/>
        </div>

        <?php $__currentLoopData = languages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="form-group col-lg-12">
            <label><?php echo e(meta('title', $language->local) ?? __('appSliders.title')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
            <input type="text" class="form-control <?php echo e($errors->has('title_'.$language->local) ? 'is-invalid' : ''); ?>" name="title_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('title', $language->local) ?? __('appSliders.title')); ?>" value='<?php echo e(old("title_{$language->local}", $appSlider[$language->local]->title ?? null)); ?>'/>
        </div>
        <div class="form-group col-lg-12">
            <label><?php echo e(meta('description', $language->local) ?? __('appSliders.description')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
            <textarea id="description_<?php echo e($language->local); ?>" name="description_<?php echo e($language->local); ?>" class="form-control my-editor <?php echo e($errors->has('description_'.$language->local) ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(meta('description', $language->local) ?? __('appSliders.description')); ?>"><?php echo e(old("description_{$language->local}", $appSlider[$language->local]->description ?? null)); ?></textarea>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        
        <div class="form-group col-lg-12">
            <label><?php echo e(meta('image', $lang) ?? __('appSliders.image')); ?> </label>
            <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="<?php echo e(old("image", $appSlider->image ?? "")); ?>"/>

            <div class="photos main_photo <?php echo e(old('image', $appSlider->image ?? '') ? ' wow fadeInUp' : 'hide'); ?>">
                <div class="col-lg-4">
                    <div class="items">
                        <div class="img">
                            <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                <img src="<?php echo e(asset(old('image', $appSlider->image ?? ''))); ?> "  id="image_holder" class="image_holder"/>
                            </a>
                        </div>
                        <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                    </div>
                </div>
            </div>

            <div class="clearfix"></div>
            <span class="input-group-btn pick_button <?php echo e(old('image', $appSlider->image ?? '') ? 'hide' : ''); ?> ">
                <a id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> Choose
                </a>
            </span>
        </div>
        


        <div class="text-center mt-5 col-12">
            <button class="butn add_button"><span><?php echo e(__('dashboard.save')); ?></span></button>
        </div>
    </form>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('inner_js'); ?>
    <!-- Editor JS files -->
    <script src="<?php echo e(asset('/assets/admin/js/lib/tinymce.min.js')); ?>"></script>
    
    <script>
        let route_prefix = "<?php echo e(url(config('lfm.prefix'))); ?>",
            url = "<?php echo e(url('/')); ?>/",
            currentLanguage = "<?php echo e($lang); ?>",
            imagePath = "<?php echo e(asset('')); ?>",
            inputName = null;
        let imgSrc = "<?php echo e(asset('assets/admin/images/file-icon.png')); ?>";
    </script>

    <script src="<?php echo e(asset('assets/admin/js/editor.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/lfm.js')); ?>"></script>
    <script>


        sendAjax('.add_button', '.add_form');

        $('select[name="type"]').change(function () {

            let thisVal = $(this).val();

            if(thisVal === 'image_only'){
                $('.service_container').addClass('d-none');
                $('.url_container').addClass('d-none');
                $('input[name="url"]').val(null);
                $('select[name="service_id"]').val(null);
            }

            if(thisVal === 'image_service'){
                $('.service_container').removeClass('d-none');
                $('.url_container').addClass('d-none');
                $('input[name="url"]').val(null);
            }

            if(thisVal === 'image_external_url'){
                $('.service_container').addClass('d-none');
                $('.url_container').removeClass('d-none');
                $('select[name="service_id"]').val(null);
            }

        });




        // $('select[name="type"]').change(async function(){
        //
        //     let serviceSelector = $('select[name="service_id"]');
        //
        //     serviceSelector.html(`<option value="">${selectTypeTitle}</option>`);
        //
        //     let typeVal = $(this).val();
        //
        //     let data = {type: typeVal},
        //         url = getServicesRoute,
        //         method = 'get';
        //
        //     const response=await ajax({
        //         url,
        //         data,
        //         dataType: 'json',
        //         method
        //     });
        //
        //     if (response.url){
        //         window.location.href = response.url;
        //     }
        //
        //     if (response.services.length){
        //         serviceSelector.html('');
        //
        //         for(let service of response.services){
        //             serviceSelector.append(`<option value="${service.id}">${service.name}</option>`)
        //         }
        //         if(typeVal === 'image_service'){
        //             $('.video_url').removeClass('d-none');
        //             $('.title_container').removeClass('d-none');
        //         } else {
        //             $('.video_url').addClass('d-none');
        //             $('input[name="video_url"]').val('');
        //             $('.title_container').addClass('d-none');
        //             $('.title_container input').val(null);
        //         }
        //
        //     }
        //
        //
        // });



    </script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('admin.layouts.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\foot\resources\views/admin/app_sliders/form.blade.php ENDPATH**/ ?>