<?php $__env->startSection('content'); ?>
    <section class="branches-pg bg-light section ">
        <div class="container">
            <div class="search_box col-lg-6 m-auto">
                <form action="<?php echo e(route('branch.index')); ?>" method="get">
                    <div class="form-group">
                        <input name="branch_name" class="form-control" placeholder="<?php echo e(__('branches.search')); ?>" type="search" value="<?php echo e(session('branch_name')); ?>"/>
                        <button class="submit_butn"><img src="<?php echo e(asset('assets/web/images/icons/search.svg')); ?>" alt="" class="filterSecondary icon"/></button>
                    </div>
                </form>
            </div>
            <div class="row mt-5">
                <?php if(count($branches)): ?>
                    <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-lg-4 col-md-6">
                            <div class="branch_card">
                                <h5 class="title fw-bold d-flex align-items-center mb-4">
                                    <span class="icon"><i class="fa-solid fa-location-dot"></i></span>
                                    <?php echo e($branch->name); ?>

                                </h5>
                                <p class="p mb-4">
                                    <img src="<?php echo e(asset('assets/web/images/icons/contact_cards_3.svg')); ?>" alt="" class="sm_icon"/>
                                    <?php echo e($branch->address); ?>

                                </p>
                                <p class="p mb-4">
                                    <img src="<?php echo e(asset('assets/web/images/icons/contact_cards_2.svg')); ?>" alt="" class="sm_icon"/>
                                    <?php echo e($branch->phone); ?>

                                </p>
                                <a data-map="<?php echo e($branch->map); ?>" href="#" class="butn gray_butn color-primary fw-bold w-100 map_link" data-bs-toggle="modal" data-bs-target="#showMapModal">
                                    <?php echo e(__('branches.show_branch_on_map')); ?>

                                </a>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                    <div class="alert text-white text-center col-lg-12" style="background-color: #3659a3"><?php echo e(__('branches.no_data')); ?></div>
                <?php endif; ?>
            </div>
        </div>
    </section>
    <!-- Modal -->
    <div class="modal fade map_modal" id="showMapModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg  modal-dialog-centered">
            <div class="modal-content">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>

                <div class="modal-body">
                    <div class="map_box map_container"></div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('inner_js'); ?>
    <script>
        $('.map_link').click(function () {
            $('.map_modal .modal-body .map_container').html($($(this).data('map')));
            $('.map_modal .modal-body .map_container iframe').attr('width', '100%').attr('height', '300');
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('web.layouts.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\foot\resources\views/web/branches/index.blade.php ENDPATH**/ ?>