<?php $__env->startSection('content'); ?>
<div class="side-title">
    <h3><?php echo e($head ?? ''); ?></h3>
</div>

<div class="border-item">
    <form class="form-row add_form" method="post" action="<?php echo e($action); ?>" enctype="multipart/form-data">
        <?php if($article ?? ''  && $article->id): ?>
            <?php echo method_field('PUT'); ?>
        <?php endif; ?>
        <?php echo csrf_field(); ?>













            <div class="form-group col-lg-3">
                <label><?php echo e(meta('news_date', $lang) ?? __('articles.news_date')); ?></label>
                <input type="date" class="form-control <?php echo e($errors->has('news_date') ? 'is-invalid' : ''); ?>" name="news_date" placeholder="<?php echo e(meta('news_date', $lang) ?? __('articles.news_date')); ?>" value='<?php echo e(old("title", $article->news_date ?? "")); ?>'/>
            </div>

            <div class="form-group col-lg-3">
                <label><?php echo e(meta('news_day', $lang) ?? __('articles.news_day')); ?></label>
                <input type="text" readonly class="form-control bg-white <?php echo e($errors->has('news_day') ? 'is-invalid' : ''); ?>" name="news_day" placeholder="<?php echo e(meta('news_day', $lang) ?? __('articles.news_day')); ?>" value='<?php echo e(old("news_day", ($article->news_date ?? null) ? date('d', strtotime($article->news_date ?? null)) : '')); ?>'/>
            </div>
            <div class="form-group col-lg-3">
                <label><?php echo e(meta('news_month', $lang) ?? __('articles.news_month')); ?></label>
                <input type="text" readonly class="form-control bg-white <?php echo e($errors->has('news_month') ? 'is-invalid' : ''); ?>" name="news_month" placeholder="<?php echo e(meta('news_month', $lang) ?? __('articles.news_month')); ?>" value='<?php echo e(old("news_month", ($article->news_date ?? null) ? date('M', strtotime($article->news_date ?? null)) : '')); ?>'/>
            </div>
            <div class="form-group col-lg-3">
                <label><?php echo e(meta('news_year', $lang) ?? __('articles.news_year')); ?></label>
                <input type="text" readonly class="form-control bg-white <?php echo e($errors->has('news_year') ? 'is-invalid' : ''); ?>" name="news_year" placeholder="<?php echo e(meta('news_year', $lang) ?? __('articles.news_year')); ?>" value='<?php echo e(old("news_year", ($article->news_date ?? null) ? date('Y', strtotime($article->news_date ?? null)) : '')); ?>'/>
            </div>
        <?php $__currentLoopData = languages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="form-group col-lg-12">
            <label><?php echo e(meta('title', $language->local) ?? __('articles.title')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
            <input type="text" class="form-control <?php echo e($errors->has('title_'.$language->local) ? 'is-invalid' : ''); ?>" name="title_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('title', $language->local) ?? __('articles.title')); ?>" value='<?php echo e(old("title_{$language->local}", $article[$language->local]->title ?? "")); ?>'/>
        </div>

        <div class="form-group col-lg-12">
            <label><?php echo e(meta('slug', $language->local) ?? __('articles.slug')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
            <input type="text" class="form-control <?php echo e($errors->has('slug_'.$language->local) ? 'is-invalid' : ''); ?>" name="slug_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('slug', $language->local) ?? __('articles.slug')); ?>" value='<?php echo e(old("slug_{$language->local}", $article[$language->local]->slug ?? "")); ?>'/>
        </div>

        <div class="form-group col-lg-12">
            <label><?php echo e(meta('keywords', $language->local) ?? __('articles.keywords')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
            <input type="text" class="form-control <?php echo e($errors->has('keywords_'.$language->local) ? 'is-invalid' : ''); ?>" name="keywords_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('keywords', $language->local) ?? __('articles.keywords')); ?>" value='<?php echo e(old("keywords_{$language->local}", $article[$language->local]->keywords ?? "")); ?>'/>

        </div>

        <div class="form-group col-lg-12">
            <label><?php echo e(meta('meta_description', $language->local) ?? __('articles.meta_description')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
            <input type="text" class="form-control <?php echo e($errors->has('meta_description_'.$language->local) ? 'is-invalid' : ''); ?>" name="meta_description_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('meta_description', $language->local) ?? __('articles.meta_description')); ?>" value='<?php echo e(old("meta_description_{$language->local}", $article[$language->local]->meta_description ?? "")); ?>'/>
        </div>

        <div class="form-group col-lg-12">
            <label><?php echo e(meta('description', $language->local) ?? __('articles.description')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
            <textarea rows="12" name="description_<?php echo e($language->local); ?>" class="form-control <?php echo e($errors->has('description_'.$language->local) ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(meta('description', $language->local) ?? __('articles.description')); ?>"><?php echo old("description_{$language->local}", stripText($article[$language->local]->description ?? "")); ?></textarea>
        </div>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        
        <div class="form-group col-lg-12 image_container">
            <label><?php echo e(meta('image', $lang) ?? __('articles.image')); ?> </label>
            <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="<?php echo e(old("image", $article->image ?? "")); ?>"/>

            <div class="photos main_photo <?php echo e(old('image', $article->image ?? '') ? ' wow fadeInUp' : 'hide'); ?>">
                <div class="col-md-4">
                    <div class="items">
                        <div class="img">
                            <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                <img src="<?php echo e(asset(old('image', $article->image ?? ''))); ?> "  id="image_holder" class="image_holder"/>
                            </a>
                        </div>
                        <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                    </div>
                </div>
            </div>

            <div class="clearfix"></div>
            <span class="input-group-btn pick_button <?php echo e(old('image', $article->image ?? '') ? 'hide' : ''); ?> ">
                <a id="lfm"  data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> <?php echo e(__('dashboard.choose')); ?>

                </a>
             </span>
        </div>
        

        <div class="text-center mt-5 col-12">
            <button class="butn add_button"><span><?php echo e(__('dashboard.save')); ?></span></button>
        </div>
    </form>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('inner_js'); ?>
    <!-- Editor JS files -->
    <script src="<?php echo e(asset('/assets/admin/js/lib/tinymce.min.js')); ?>"></script>

    <script>
        let route_prefix = "<?php echo e(url(config('lfm.prefix'))); ?>",
            url = "<?php echo e(url('/')); ?>/",
            currentLanguage = "<?php echo e($lang); ?>",
            imagePath = "<?php echo e(asset('')); ?>",
            inputName = null;
    </script>
    <script src="<?php echo e(asset('assets/admin/js/editor.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/lfm.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/articles.js')); ?>"></script>

    <script>
        sendAjax('.add_button', '.add_form');

        $('input[name="news_date"]').change(function () {
            let date = new Date($(this).val());
                // newDate = date.toLocaleDateString().split('/');
                if($(this).val()){
                let newDate = date.toString().split(' ');
                $('input[name="news_day"]').val(newDate[2]);
                $('input[name="news_month"]').val(newDate[1]);
                $('input[name="news_year"]').val(newDate[3]);
            } else {
                    $('input[name="news_day"]').val('');
                    $('input[name="news_month"]').val('');
                    $('input[name="news_year"]').val('');
                }


            // newsDay = date.getDate(),
            // newsMonth = (date.getMonth()+1),
            // newsYear = date.getFullYear();

        })
    </script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('admin.layouts.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp\www\makkah\resources\views/admin/articles/form.blade.php ENDPATH**/ ?>