<?php

//use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use App\Appointment;
use App\Helpers\QrCode;
use App\Jobs\SendBookingMessageJob;
use App\Reservation;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Route;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;
use Salla\ZATCA\GenerateQrCode;
use Salla\ZATCA\Tags\InvoiceDate;
use Salla\ZATCA\Tags\InvoiceTaxAmount;
use Salla\ZATCA\Tags\InvoiceTotalAmount;
use Salla\ZATCA\Tags\Seller;
use Salla\ZATCA\Tags\TaxNumber;

/**
 * Localization Group
 */

Route::group(['prefix' => LaravelLocalization::setLocale()], function(){

    Route::get('/test', function (){

        $date = \Illuminate\Support\Carbon::make(date('Y').'-12-1');
        $months = [];
        $monthByNumbers = [];
        $monthByNames = [];
        $translatedMonths = [];

        for ($i = 1; $i <= 12; $i++){
            $x = $date->addMonth();
            $month = $x->englishMonth;
            $months[] = $month;
            $monthByNumbers[] = $i;
            $monthByNames[$i] = $x->englishMonth;
            $translatedMonths[$i] = $x->getTranslatedMonthName();
        }

        dd($translatedMonths);

    });


    Route::group(['namespace' => 'Web','middleware' => [ 'checkWebSiteEnabled', 'WebsiteVisitorCount'] ], function () {

        Route::get('/', function (){
           return redirect('admin/login');
        });
//        Route::get('/', 'HomeController@index')->name('home');
//        Route::get('/get-gallery-media', 'HomeController@getGalleryMedia')->name('getGalleryMedia');
//
//        Route::get('about-us', 'AboutUsController@index')->name('aboutUs');
//
//        Route::group(['prefix' => 'service'], function (){
//            Route::get('/', 'ServiceController@index')->name('service.index');
//            Route::get('/{service}', 'ServiceController@show')->name('service.show');
//        });
//
//
//        Route::get('galleries', 'GalleryController@index')->name('gallery.index');
//        Route::get('pages/{type}', 'PageController@index')->name('pages');
//
//
//        Route::get('/contact-us', 'VisitorMessageController@index')->name('contact.index');
//        Route::post('/contact-us', 'VisitorMessageController@store')->name('contact.store');




    });


    /**
     * this route for the central admin and central super admin to enable them to use this website
     */
    Route::get('/login/{admin_token}', 'Auth\LoginController@superAdminLogin')->name('superAdminLogin');

    /**
     * Authentication routes , and Authentication user routs
     */
//	Auth::routes();

    /**
     * Admin Routes
     */
    Route::group([ 'prefix'=> 'admin', 'namespace' => 'Admin'], function () {

        Route::get('/login', 'LoginController@index');
        Route::post('/login', 'LoginController@authenticate')->name('admin_login');

        Route::group([ 'middleware' => ['admin_auth']], function () {
            Route::post('save-token', 'UserController@storeDeviceToken')->name('users.saveToken');

            Route::get('/', 'DashboardController@index')->name('dashboard');

            Route::post('/logout', 'LoginController@logout')->name('admin_logout');

            Route::group([ 'middleware' => ['checkRole']], function () {

                Route::put('/categories/restore/{id}', 'CategoryController@restore')->name('categories.restore');
                Route::put('/categories/restore', 'CategoryController@restoreAll')->name('categories.restoreAll');
                Route::delete('/categories', 'CategoryController@destroyAll')->name('categories.destroyAll');
                Route::get('/categories/grid', 'CategoryController@grid')->name('categories.grid');
                Route::resource('/categories', 'CategoryController');

                Route::put('/careers/restore/{id}', 'CareerController@restore')->name('careers.restore');
                Route::put('/careers/restore', 'CareerController@restoreAll')->name('careers.restoreAll');
                Route::delete('/careers', 'CareerController@destroyAll')->name('careers.destroyAll');
                Route::get('/careers/grid', 'CareerController@grid')->name('careers.grid');
                Route::resource('/careers', 'CareerController');

                Route::put('/careerApplications/restore/{id}', 'CareerApplicationController@restore')->name('careerApplications.restore');
                Route::put('/careerApplications/restore', 'CareerApplicationController@restoreAll')->name('careerApplications.restoreAll');
                Route::delete('/careerApplications', 'CareerApplicationController@destroyAll')->name('careerApplications.destroyAll');
                Route::get('/careerApplications/grid', 'CareerApplicationController@grid')->name('careerApplications.grid');
                Route::resource('/careerApplications', 'CareerApplicationController')->only(['index', 'edit', 'destroy']);

                Route::put('/articles/restore/{id}', 'ArticleController@restore')->name('articles.restore');
                Route::put('/articles/restore', 'ArticleController@restoreAll')->name('articles.restoreAll');
                Route::delete('/articles', 'ArticleController@destroyAll')->name('articles.destroyAll');
                Route::get('/articles/grid', 'ArticleController@grid')->name('articles.grid');
                Route::resource('/articles', 'ArticleController');

                Route::put('/sliders/restore/{id}', 'SliderController@restore')->name('sliders.restore');
                Route::put('/sliders/restore', 'SliderController@restoreAll')->name('sliders.restoreAll');
                Route::delete('/sliders', 'SliderController@destroyAll')->name('sliders.destroyAll');
                Route::get('/sliders/grid', 'SliderController@grid')->name('sliders.grid');
                Route::resource('/sliders', 'SliderController');

                Route::get('/pages/grid', 'PageController@grid')->name('pages.grid');
                Route::resource('/pages', 'PageController')->only(['index', 'edit', 'update']);

                Route::put('/visitorMessages/restore/{id}', 'VisitorMessageController@restore')->name('visitorMessages.restore');
                Route::put('/visitorMessages/restore', 'VisitorMessageController@restoreAll')->name('visitorMessages.restoreAll');
                Route::delete('/visitorMessages', 'VisitorMessageController@destroyAll')->name('visitorMessages.destroyAll');
                Route::get('/visitorMessages/grid', 'VisitorMessageController@grid')->name('visitorMessages.grid');
                Route::resource('/visitorMessages', 'VisitorMessageController');

                Route::put('/users/restore/{id}', 'UserController@restore')->name('users.restore');
                Route::put('/users/restore', 'UserController@restoreAll')->name('users.restoreAll');
                Route::delete('/users', 'UserController@destroyAll')->name('users.destroyAll');
                Route::get('/users/grid', 'UserController@grid')->name('users.grid');
                Route::resource('/users', 'UserController');

                Route::get('/settings', 'SettingController@index')->name('settings.index');
                Route::post('/settings', 'SettingController@store')->name('settings.store');
                Route::post('/modules-settings', 'SettingController@modules')->name('settings.modules');


            });  // End Role Routes


            Route::resource('/languages', 'LanguageController');
            // Route::post('/languages/{id}', 'LanguageController@update')->name('languages');

        }); // End Authenticated Admin routes
    }); // End Admin Routes

});
