@if(count($rooms))
    @foreach($rooms as $room)
        <div class="col-lg-3 col-md-6">
            <div class="form-check">
                <input data-price="{{$room->room_price}}" class="form-check-input" type="radio" name="room_id" id="roomRadio{{$loop->iteration}}" value="{{$room->id}}">
                <label class="form-check-label" for="roomRadio{{$loop->iteration}}">
                    <div class="room_item">
                        <div class="img">
                            <img src="{{asset($room->image)}}" alt="">
                            <span class="stars">
                                @if($room->rate)
                                    @for($i = 1; $i <= $room->rate; $i++)
                                        <i class="far fa-star"></i>
                                    @endfor
                                @else
                                    {{__('rooms.no_evaluates')}}
                                @endif
                            </span>
                        </div>
                        <div class="info">
                            <h4 class="title">{{$room->name}}</h4>
                            <a target="_blank" href="{{route('room.show', $room->id)}}" class="mor_btn"> <i class="bi bi-eye me-1"></i>{{__('rooms.see_room')}}</a>
                        </div>
                    </div>
                </label>
            </div>
        </div>
    @endforeach
    @else
    <div style="background-color: #cd9b39" class="alert text-center">{{__('rooms.no_data')}}</div>
@endif
