@extends('web.layouts.layout')

@section('container_content')
    @include('web.layouts.nav')
    @if(\Illuminate\Support\Facades\Route::currentRouteName() == 'home')
        @include('web.layouts.home_header')
    @else
        @include('web.layouts.page_header')
    @endif
    @yield('content')


    <div class="modal fade success_modal" id="success_modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body text-center">
                    <div class="icon mb-4">
                        <img src="{{asset('assets/web/images/icons/checked.png')}}" alt="" class="filterPrimary">
                    </div>
                    <h2 class="title">{{session('success_message')}}</h2>
                    <button type="button" class="butn primary_border_butn m-auto mt-4 px-4" data-bs-dismiss="modal"> <span> {{__('main.close')}} </span> </button>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade canceled_modal" id="canceled_modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body text-center">
                    <div class="icon mb-4">
                        <img src="{{asset('assets/web/images/icons/canceled.png')}}" alt="" class="filterPrimary">
                    </div>
                    <h2 class="title">{{session('error_message')}}</h2>
                    <button type="button" class="butn primary_border_butn m-auto mt-4 px-4" data-bs-dismiss="modal"> <span> {{__('main.close')}} </span> </button>
                </div>
            </div>
        </div>
    </div>

    @include('web.layouts.footer')


@endsection

@section('container_js')
    <script>
        axios.defaults.headers.common = {
            'X-Requested-With': 'XMLHttpRequest',
            'X-CSRF-TOKEN' : document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        };
    </script>

    <script>
        $(document).ready(function () {
            if("{{session('success_message')}}"){
                $('.success_modal').modal('show');
            }

            if("{{session('error_message')}}"){
                $('.canceled_modal').modal('show')
            }
        })
    </script>

    <script>
        let newsletterErrorMessage = "{{__('newsletters.enter_email')}}";
    </script>

    <script src="{{ asset('assets/web/js/actions.js') }}"></script>

    <script>
        {{--    @if(session('store_device_token'))--}}
        {{--        @include('web.layouts.firebase')--}}
        {{--        {{session()->forget(['store_device_token'])}}--}}
        {{--    @endif--}}
    </script>
    @yield('inner_js')
@endsection
