@if(!in_array(\Illuminate\Support\Facades\Route::currentRouteName(), ['user.login', 'user.register']))
<!-- ------------ num_contact ----------- -->
<section class="num_contact bl_back py-5 wow fadeInUp">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-8">
                <h3 class="text-light">{{contactUsBox()['contactTitle1'] ?? __('main.contact_us_sec_hint')}} <strong class="main_color"> {{contactUsBox()['contactTitle2'] ?? __('main.free_consulting')}}</strong></h3>
                <div class="text text-light">{{stripText(contactUsBox()['contact_box_description'] ?? null)}}</div>
            </div>
            <div class="col-lg-4 text-end">
                <a href="{{route('contactUs')}}" class="butn">
                    <span>{{__('visitorMessages.head')}}</span>
                </a>
            </div>
        </div>
    </div>
</section>
<!-- ------------ partners ----------- -->

@if(count($partners))
    <section id="partners" class="partners wow fadeInUp">
        <div class="container">
            <div class="section_head">
                <h6> <img src="{{asset('assets/web/images/sec_head_sh.svg')}}" alt=""> {{__('partners.head')}} </h6>
                <h2>{{__('main.partner_we_proud')}}</h2>
            </div>
            <div class="content">
                <div class="partners_slider">
                    <div class="swiper-container">
                        <div class="swiper-wrapper">
                            @foreach($partners as $partner)
                                <div class="swiper-slide">
                                    @if($partner->url)
                                        <div class="img text-center">
                                            <a target="_blank" href="{{$partner->url}}">
                                                <img src="{{asset($partner->image)}}" alt="">
                                            </a>
                                        </div>
                                    @else
                                        <div class="img">
                                            <img src="{{asset($partner->image)}}" alt="">
                                        </div>
                                    @endif
                                </div>
                            @endforeach
                        </div>
                        <div class="swiper-pagination"></div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endif
@endif
<section class="subscribe">
    <div class="container">
        <div class="content">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <div class="info">
                        <p>{{__('main.newsletters_title')}}</p>
                        <h3>{{__('main.subscribe_in')}} <strong class="main_color">{{__('main.newsletters')}}</strong></h3>
                    </div>
                </div>
                <div class="col-lg-6">
                    <form method="post" action="{{route('newsletter')}}" class="form newsletter_form">
                        @csrf
                        <div class="form-group">
                            <input type="text" name="email" class="form-control newsletter_email" placeholder="{{__('main.enter_email_here')}}">
                            <button class="butn newsletter_button">
                                <span>{{__('main.send')}}</span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
