@extends('web.layouts.container')

@section('content')
    <section class="contact-pg bg-light section ">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <h1 class="sec_title mb-5">  {{__('visitorMessages.send_message')}} </h1>
                    <div class="form_box">
                        <form method="post" action="{{route('contact.store')}}" class="contact_us_form">
                            <div class="form-group mb-4">
                                <label class="label mb-2">{{__('visitorMessages.name')}} <span class="text-danger">*</span></label>
                                <input type="text" name="name" class="form-control" placeholder="{{__('visitorMessages.type_here')}}">
                            </div>
                            <div class="form-group mb-4">
                                <label class="label mb-2">{{__('visitorMessages.email')}}<span class="text-danger">*</span></label>
                                <input style="direction: rtl" type="email" name="email" class="form-control" placeholder="{{__('visitorMessages.type_here')}}">
                            </div>
                            <div class="form-group mb-4">
                                <label class="label mb-2">{{__('visitorMessages.phone')}}<span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text" id="basic-addon1">+966</span>
                                    <input style="direction: rtl" type="tel" name="phone" class="form-control" placeholder="XXXXXXXXXXXX">
                                </div>
                            </div>
{{--                            <div class="form-group mb-4">--}}
{{--                                <label class="label mb-2">{{__('visitorMessages.subject')}}<span class="text-danger">*</span></label>--}}
{{--                                <input type="text" name="subject" class="form-control" placeholder="{{__('visitorMessages.type_here')}}">--}}
{{--                            </div>--}}
                            <div class="form-group mb-4">
                                <label class="label mb-2">{{__('visitorMessages.message')}}  <span class="text-danger">*</span></label>
                                <textarea name="message" class="form-control" placeholder="{{__('visitorMessages.type_here')}}" rows="5"></textarea>
                            </div>
                            <button class="butn secondary_butn w-100 py-3 fs-6 contact_us_button">{{__('visitorMessages.send')}} </button>
                        </form>
                    </div>
                </div>
                <div class="col-lg-6">
                    <h1 class="sec_title mb-5">{{__('workHours.head')}}</h1>
                    <div class="hours_box">
                        @if(count($workHours))
                            @foreach($workHours as $day => $workHour)
                                <div class="item">
                                    <div class="row">
                                        <div class="col-4">
                                            <span class="day">{{__('workHours.'.$day)}}</span>
                                        </div>
                                        <div class="col-8">
                                            <span class="hours color-secondary">{{$workHour}}</span>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        @endif
                    </div>
                </div>
                <div class="col-lg-12 mt-5">
                    <h1 class="sec_title mb-5">{{__('settings.site_map')}}</h1>
                    <div class="map_box map_container">{!! $settings['site_map'] !!}</div>
                </div>
                <div class="col-lg-12 mt-5">
                    <h1 class="sec_title mb-5">{{__('visitorMessages.management_info')}}</h1>
                    <div class="about_cards contact_cards mt-0">
                        <div class=" zi-5">
                            <div class="row pb-4">
                                @if($settings['site_email'] ?? null)
                                    <div class="col-lg-4">
                                        <div class="about_card">
                                            <img src="{{asset('assets/web/images/icons/contact_cards_1.svg')}}" alt="" class="icon"/>
                                            <h5 class="title fw-bold">{{__('settings.site_email')}}</h5>
                                            <p class="p">{{$settings['site_email']}}</p>
                                        </div>
                                    </div>
                                @endif
                                @if($settings['site_phone'] ?? null)
                                    <div class="col-lg-4">
                                        <div class="about_card">
                                            <img src="{{asset('assets/web/images/icons/contact_cards_2.svg')}}" alt="" class="icon"/>
                                            <h5 class="title fw-bold">{{__('settings.site_phone')}}</h5>
                                            <p class="p">{{$settings['site_phone']}}</p>
                                        </div>
                                    </div>
                                @endif
                                @if($settings['site_address_'.$lang] ?? null)
                                    <div class="col-lg-4">
                                        <div class="about_card">
                                            <img src="{{asset('assets/web/images/icons/contact_cards_3.svg')}}" alt="" class="icon"/>
                                            <h5 class="title fw-bold">{{__('settings.site_address')}}</h5>
                                            <p class="p">{{$settings['site_address_'.$lang]}}</p>
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                        <div class="social_links d-flex justify-content-center">
                            @if($settings['instagram'] ?? null)
                                <a target="_blank" href="{{$settings['instagram']}}">
                                    <img src="{{asset('assets/web/images/icons/instagram.svg')}}" alt="" class="icon"/>
                                </a>
                            @endif
                            @if($settings['twitter'] ?? null)
                                <a target="_blank" href="{{$settings['twitter']}}">
                                    <img src="{{asset('assets/web/images/icons/twitter.svg')}}" alt="" class="icon"/>
                                </a>
                            @endif
                            @if($settings['facebook'] ?? null)
                                <a target="_blank" href="{{$settings['facebook']}}">
                                    <img src="{{asset('assets/web/images/icons/fb.svg')}}" alt="" class="icon"/>
                                </a>
                            @endif
                        </div>

                        <img src="{{asset('assets/web/images/vector-2.svg')}}" alt="" class="vector_bl"/>
                        <img src="{{asset('assets/web/images/vector-1.svg')}}" alt="" class="vector_tr"/>

                    </div>

                </div>
            </div>
        </div>
    </section>
@endsection

@section('inner_js')

    <script>

        $('.contact_us_button').click(async function (e) {
            e.preventDefault();

            $(this).prop('disabled', true);

            let form = $('.contact_us_form'),
                data = new FormData(form[0]),
                url = form.attr('action'),
                method = form.attr('method');

            const response=await ajax({
                url,
                data,
                dataType: 'json',
                method
            });

            if (response.errors){
                $(this).prop('disabled', false);
                toasterError(response.errors);
            }

            if (response.message){
                toasterSuccess(response.message);
                $('input, textarea').val('');
            }

        });

        $(document).ready(function () {
            $('.map_container iframe').attr('width', '100%').attr('height', '400')
        })
    </script>

@endsection
