@extends('web.layouts.container')

@section('content')
    <section class="rate-sec booking-pg section bg-light">
        <div class="container">
            <div class="inner">
                <h1 class="sec_title m-auto mb-5"> {{__('reservations.evaluate') . ' ' . $serviceName}}  </h1>
                <form action="{{route('booking.addEvaluate', [$booking->id, $booking->evaluate_token])}}" method="post" class="col-lg-10 m-auto evaluate_form">
                    <div class="stars-content mb-5">
                        <div class="star-rating">
                            <input type="radio" id="5-stars" name="rate" value="5" />
                            <label for="5-stars" class="star"><i class="fa-solid fa-star"></i></label>
                            <input type="radio" id="4-stars" name="rate" value="4" />
                            <label for="4-stars" class="star"><i class="fa-solid fa-star"></i></label>
                            <input type="radio" id="3-stars" name="rate" value="3" />
                            <label for="3-stars" class="star"><i class="fa-solid fa-star"></i></label>
                            <input type="radio" id="2-stars" name="rate" value="2" />
                            <label for="2-stars" class="star"><i class="fa-solid fa-star"></i></label>
                            <input type="radio" id="1-star" name="rate" value="1" />
                            <label for="1-star" class="star"><i class="fa-solid fa-star"></i></label>
                        </div>
                    </div>
                    <div class="form-group col-md-10 m-auto">
                        <h6 class="title  mb-3">{{__('evaluates.comment')}}</h6>
                        <textarea name="comment" class="form-control" placeholder="{{__('evaluates.type_here')}}" rows="7"></textarea>
                    </div>
                    <div class="inFlex justify-content-center mt-5">
                        <button class="butn primary_butn mx-1 px-5 fw-bold fs-6 evaluate_button">{{__('evaluates.evaluate')}}</button>
                    </div>
                </form>
            </div>
        </div>
    </section>
@endsection

@section('inner_js')



    <script>

        $('.evaluate_button').click(async function (e) {
            e.preventDefault();

            // $(this).prop('disabled', true);

            let form = $('.evaluate_form'),
                data = new FormData(form[0]),
                url = form.attr('action'),
                method = form.attr('method');

            const response=await ajax({
                url,
                data,
                dataType: 'json',
                method
            });

            if (response.errors){
                $(this).prop('disabled', false);
                toasterError(response.errors);
            }

            if (response.message){
                toasterSuccess(response.message);
                setTimeout(function () {
                    window.location.href = response.url;
                }, 200)
            }

        });
        </script>

@endsection
