@extends('admin.layouts.container')

@section('content')
    <div class="side-title">
        <h3>{{ $head ?? '' }}</h3>
    </div>

    <div class="border-item">
        <form class="form-row" method="post" action="{{ $action }}">
            @if($user ?? ''  && $user->id)
                @method('PUT')
            @endif
            @CSRF

            <div class="form-group col-lg-4">
                <label>{{ meta('name', $lang) ?? __('users.name') }} </label>
                <input type="text" class="form-control {{ $errors->has('name') ? 'is-invalid' : '' }}" name="name" placeholder="{{ meta('name', $lang) ??__('users.name') }}" value='{{ old("name", $user->name ?? "") }}'/>
            </div>

            <div class="form-group col-lg-4">
                <label>{{ meta('email', $lang) ?? __('users.email') }} </label>
                <input type="text" class="form-control {{ $errors->has('email') ? 'is-invalid' : '' }}" name="email" placeholder="{{ meta('email', $lang) ?? __('users.email') }}" value='{{ old("email", $user->email ?? "") }}' {{ ($user->email ?? null) ? "readonly" : "" }}/>
            </div>

            <div class="form-group col-lg-4">
                <label>{{ meta('phone', $lang) ?? __('users.phone') }} </label>
                <input type="text" class="form-control {{ $errors->has('phone') ? 'is-invalid' : '' }}" name="phone" placeholder="{{ meta('phone', $lang) ?? __('users.phone') }}" value='{{ old("phone", $user->phone ?? "") }}'/>
            </div>
            <div class="form-group col-lg-6">
                <label>{{ meta('password', $lang) ?? __('users.password') }} </label>
                <input type="password" class="form-control {{ $errors->has('password') ? 'is-invalid' : '' }}" name="password" placeholder="{{ meta('password', $lang) ?? __('users.password') }}" value='{{ old("password", "") }}'/>
            </div>

            <div class="form-group col-lg-6">
                <label>{{ meta('password_confirmation', $lang) ?? __('users.password_confirmation') }} </label>
                <input type="password" class="form-control {{ $errors->has('password_confirmation') ? 'is-invalid' : '' }}" name="password_confirmation" placeholder="{{ meta('password_confirmation', $lang) ?? __('users.password_confirmation') }}" value='{{ old("password_confirmation", "") }}'/>
            </div>

            @if(auth()->user()->role != 'sub_admin' && ($user->role ?? $request->role ?? 'sub_admin') == 'sub_admin')
                @if( count($modules) >= 1 )
                    <div class="form-group col-lg-12">
                        <label>{{ meta('modules', $lang) ??  __('users.modules') }} </label>
                        <div class="clearfix"></div>
                        <div class="row">
                            @foreach($modules as $key=> $row)
                                <div class="col-sm-4">
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" {{ in_array($row['id'], $user_modules) ? 'checked' : '' }} value="{{ $row['id'] }}" class="custom-control-input" id="module_{{ $key }}" name="modules[]">
                                        <label class="custom-control-label" for="module_{{ $key }}"> {{ $row->meta['module_name'][$lang] ?? __($row['path'].'.head') }} </label>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endif
            @endif

                {{--Start image container--}}
                <div class="form-group col-lg-6">
                    <label>{{ meta('photo', $lang) ?? __('users.photo') }} </label>
                    <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="photo" value="{{old("photo", $user->photo ?? "")}}"/>

                    <div class="photos main_photo {{ old('photo', $user->photo ?? '') ? ' wow fadeInUp' : 'hide' }}">
                        <div class="col-lg-12">
                            <div class="items">
                                <div class="img">
                                    <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                        <img src="{{asset(old('photo', $user->photo ?? ''))}} "  id="image_holder" class="image_holder"/>
                                    </a>
                                </div>
                                <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                            </div>
                        </div>
                    </div>

                    <div class="clearfix"></div>
                    <span class="input-group-btn pick_button {{ old('photo', $user->photo ?? '') ? 'hide' : '' }} ">
                    <a id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                        <i class="fas fa-camera-retro"></i> Choose
                    </a>
                </span>
                </div>
                {{--End image container--}}

            <div class="text-center mt-5 col-12">
                <button class="butn"><span>{{ __('dashboard.save') }}</span></button>
            </div>
        </form>
    </div>

@endsection

@section('inner_js')
    <!-- Editor JS files -->
    {{--    <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>--}}
    <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>
    <script>
        let route_prefix = "{{ url(config('lfm.prefix')) }}",
            url = "{{url('/')}}/",
            currentLanguage = "{{$lang}}",
            imagePath = "{{asset('')}}",
            inputName = null;
    </script>
    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>
@endsection
