@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{$head ?? '' }}</h3>
</div>

<div class="border-item">
    <form class="form-row add_form" method="post" action="{{ $action }}" enctype="multipart/form-data">
        @if($slider ?? ''  && $slider->id)
            @method('PUT')
        @endif
        @csrf

        @foreach(languages() as $language)

                <div class="form-group col-lg-6">
                    <label>{{ meta('first_title', $language->local) ?? __('sliders.first_title') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                    <input type="text" class="form-control {{ $errors->has('first_title_'.$language->local) ? 'is-invalid' : '' }}" name="first_title_{{ $language->local }}" placeholder="{{ meta('first_title', $language->local) ?? __('sliders.first_title') }}" value='{{ old("first_title_{$language->local}", $slider[$language->local]->first_title ?? "") }}'/>
                </div>
                <div class="form-group col-lg-6">
                    <label>{{ meta('second_title', $language->local) ?? __('sliders.second_title') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                    <input type="text" class="form-control {{ $errors->has('second_title_'.$language->local) ? 'is-invalid' : '' }}" name="second_title_{{ $language->local }}" placeholder="{{ meta('second_title', $language->local) ?? __('sliders.second_title') }}" value='{{ old("second_title_{$language->local}", $slider[$language->local]->second_title ?? "") }}'/>
                </div>
            <div class="form-group col-lg-12">
                <label>{{ meta('description', $language->local) ?? __('sliders.description') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                <textarea name="description_{{ $language->local }}" class="form-control my-editor {{ $errors->has('description_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('description', $language->local) ?? __('sliders.description') }}">{{ old("description_{$language->local}", $slider[$language->local]->description ?? "") }}</textarea>
            </div>

        @endforeach

{{--        @if($slider->id == 5)--}}
{{--            <div class="form-group col-lg-12">--}}
{{--                <label>{{ meta('button_url', $lang) ?? __('sliders.button_url') }}</label>--}}
{{--                <input type="text" class="form-control {{ $errors->has('button_url') ? 'is-invalid' : '' }}" name="button_url" placeholder="{{ meta('button_url', $lang) ?? __('sliders.button_url') }}" value='{{ old("button_url", $slider->button_url ?? "") }}'/>--}}
{{--            </div>--}}
{{--        @endif--}}

        {{--Start image container--}}
        <div class="form-group col-lg-12">
            <label>{{ meta('image', $lang) ?? __('sliders.image') }} </label>
            <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="{{old("image", $slider->image ?? null)}}"/>

            <div class="photos main_photo {{ old('image', $slider->image ?? null) ? ' wow fadeInUp' : 'hide' }}">
                <div class="col-lg-4">
                    <div class="items">
                        <div class="img">
                            <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                <img src="{{($slider->image ?? null) ? asset(old('image', $slider->image ?? null)) : ''}} "  id="image_holder" class="image_holder"/>
                            </a>
                        </div>
                        <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                    </div>
                </div>
            </div>

            <div class="clearfix"></div>
            <span class="input-group-btn pick_button {{ old('image', $slider->image ?? null) ? 'hide' : '' }} ">
                <a id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> {{__('dashboard.choose')}}
                </a>
            </span>
        </div>
        {{--End image container--}}

        <div class="text-center mt-5 col-12">
            <button class="butn add_button"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>

@endsection

@section('inner_js')
{{--    <!-- Editor JS files -->--}}
        <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>
{{--    <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>--}}
    <script>
        var route_prefix = "{{ url(config('lfm.prefix')) }}";
        var url = "{{url('/')}}/",
        currentLanguage = "{{$lang}}",
        inputName = null;
    </script>
    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>

<script>
    sendAjax('.add_button', '.add_form')
</script>

@endsection



