@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{ $head ?? ''}}</h3>
</div>

<div class="border-item">
    <form class="form-row add_form" method="post" action="{{ $action }}" enctype="multipart/form-data">
        @if($article ?? ''  && $article->id)
            @method('PUT')
        @endif
        @csrf
{{--            <div class="form-group col-lg-12">--}}
{{--                <label>{{ meta('category_id', $lang) ?? __('articles.category_id') }} </label>--}}
{{--                <select name="category_id" class="form-control {{ $errors->has('category_id') ? 'is-invalid' : '' }}">--}}
{{--                    <option value="">{{__('articles.category_id')}}</option>--}}
{{--                    @if(count($categories))--}}
{{--                        @foreach($categories as $category)--}}
{{--                            <option {{($article->category_id ?? null) == $category->id ? 'selected' : ''}} value="{{$category->id}}">{{$category->name}}</option>--}}
{{--                        @endforeach--}}
{{--                    @endif--}}
{{--                </select>--}}
{{--            </div>--}}


            <div class="form-group col-lg-3">
                <label>{{ meta('news_date', $lang) ?? __('articles.news_date') }}</label>
                <input type="date" class="form-control {{ $errors->has('news_date') ? 'is-invalid' : '' }}" name="news_date" placeholder="{{ meta('news_date', $lang) ?? __('articles.news_date') }}" value='{{ old("title", $article->news_date ?? "") }}'/>
            </div>

            <div class="form-group col-lg-3">
                <label>{{ meta('news_day', $lang) ?? __('articles.news_day') }}</label>
                <input type="text" readonly class="form-control bg-white {{ $errors->has('news_day') ? 'is-invalid' : '' }}" name="news_day" placeholder="{{ meta('news_day', $lang) ?? __('articles.news_day') }}" value='{{ old("news_day", ($article->news_date ?? null) ? date('d', strtotime($article->news_date ?? null)) : '')}}'/>
            </div>
            <div class="form-group col-lg-3">
                <label>{{ meta('news_month', $lang) ?? __('articles.news_month') }}</label>
                <input type="text" readonly class="form-control bg-white {{ $errors->has('news_month') ? 'is-invalid' : '' }}" name="news_month" placeholder="{{ meta('news_month', $lang) ?? __('articles.news_month') }}" value='{{ old("news_month", ($article->news_date ?? null) ? date('M', strtotime($article->news_date ?? null)) : '')}}'/>
            </div>
            <div class="form-group col-lg-3">
                <label>{{ meta('news_year', $lang) ?? __('articles.news_year') }}</label>
                <input type="text" readonly class="form-control bg-white {{ $errors->has('news_year') ? 'is-invalid' : '' }}" name="news_year" placeholder="{{ meta('news_year', $lang) ?? __('articles.news_year') }}" value='{{ old("news_year", ($article->news_date ?? null) ? date('Y', strtotime($article->news_date ?? null)) : '')}}'/>
            </div>
        @foreach(languages() as $language)
        <div class="form-group col-lg-12">
            <label>{{ meta('title', $language->local) ?? __('articles.title') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <input type="text" class="form-control {{ $errors->has('title_'.$language->local) ? 'is-invalid' : '' }}" name="title_{{ $language->local }}" placeholder="{{ meta('title', $language->local) ?? __('articles.title') }}" value='{{ old("title_{$language->local}", $article[$language->local]->title ?? "") }}'/>
        </div>

        <div class="form-group col-lg-12">
            <label>{{ meta('slug', $language->local) ?? __('articles.slug') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <input type="text" class="form-control {{ $errors->has('slug_'.$language->local) ? 'is-invalid' : '' }}" name="slug_{{ $language->local }}" placeholder="{{ meta('slug', $language->local) ?? __('articles.slug')}}" value='{{ old("slug_{$language->local}", $article[$language->local]->slug ?? "") }}'/>
        </div>

        <div class="form-group col-lg-12">
            <label>{{ meta('keywords', $language->local) ?? __('articles.keywords')}} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <input type="text" class="form-control {{ $errors->has('keywords_'.$language->local) ? 'is-invalid' : '' }}" name="keywords_{{ $language->local }}" placeholder="{{ meta('keywords', $language->local) ?? __('articles.keywords')}}" value='{{ old("keywords_{$language->local}", $article[$language->local]->keywords ?? "") }}'/>

        </div>

        <div class="form-group col-lg-12">
            <label>{{ meta('meta_description', $language->local) ?? __('articles.meta_description')}} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <input type="text" class="form-control {{ $errors->has('meta_description_'.$language->local) ? 'is-invalid' : '' }}" name="meta_description_{{ $language->local }}" placeholder="{{ meta('meta_description', $language->local) ?? __('articles.meta_description')}}" value='{{ old("meta_description_{$language->local}", $article[$language->local]->meta_description ?? "") }}'/>
        </div>

        <div class="form-group col-lg-12">
            <label>{{ meta('description', $language->local) ?? __('articles.description')}} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <textarea rows="12" name="description_{{ $language->local }}" class="form-control {{ $errors->has('description_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('description', $language->local) ?? __('articles.description')}}">{!! old("description_{$language->local}", stripText($article[$language->local]->description ?? "")) !!}</textarea>
        </div>

        @endforeach

        {{--Start image container--}}
        <div class="form-group col-lg-12 image_container">
            <label>{{ meta('image', $lang) ?? __('articles.image') }} </label>
            <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="{{old("image", $article->image ?? "")}}"/>

            <div class="photos main_photo {{ old('image', $article->image ?? '') ? ' wow fadeInUp' : 'hide' }}">
                <div class="col-md-4">
                    <div class="items">
                        <div class="img">
                            <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                <img src="{{asset(old('image', $article->image ?? ''))}} "  id="image_holder" class="image_holder"/>
                            </a>
                        </div>
                        <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                    </div>
                </div>
            </div>

            <div class="clearfix"></div>
            <span class="input-group-btn pick_button {{ old('image', $article->image ?? '') ? 'hide' : '' }} ">
                <a id="lfm"  data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> {{__('dashboard.choose')}}
                </a>
             </span>
        </div>
        {{--End image container--}}

        <div class="text-center mt-5 col-12">
            <button class="butn add_button"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>

@endsection

@section('inner_js')
    <!-- Editor JS files -->
    <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>
{{--        <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>--}}
    <script>
        let route_prefix = "{{ url(config('lfm.prefix')) }}",
            url = "{{url('/')}}/",
            currentLanguage = "{{$lang}}",
            imagePath = "{{asset('')}}",
            inputName = null;
    </script>
    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>
    <script src="{{ asset('assets/admin/js/articles.js') }}"></script>

    <script>
        sendAjax('.add_button', '.add_form');

        $('input[name="news_date"]').change(function () {
            let date = new Date($(this).val());
                // newDate = date.toLocaleDateString().split('/');
                if($(this).val()){
                let newDate = date.toString().split(' ');
                $('input[name="news_day"]').val(newDate[2]);
                $('input[name="news_month"]').val(newDate[1]);
                $('input[name="news_year"]').val(newDate[3]);
            } else {
                    $('input[name="news_day"]').val('');
                    $('input[name="news_month"]').val('');
                    $('input[name="news_year"]').val('');
                }


            // newsDay = date.getDate(),
            // newsMonth = (date.getMonth()+1),
            // newsYear = date.getFullYear();

        })
    </script>
@endsection



