<?php

use Illuminate\Database\Seeder;

class TagSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        factory(\App\Tag::class, 8)->create();

        $names = [
            'News',
            'Latest News',
            'Technology',
            'References',
            'Books',
            'Tourism',
            'Tags',
            'Category',
        ];

        foreach (languages() as $language) {
            foreach ($names as $id => $name) {
                factory(\App\TagDescription::class)->create([
                    'name' => $name,
                    'tag_id' => ($id+1),
                    'language_id' => $language->id,
                ]);
            }
        }
    }

}
