<?php

use Illuminate\Database\Seeder;

class SliderSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $images = [
            'assets/web/images/header-1.png',
            'assets/web/images/header-2.jpg',
        ];

        foreach ($images as $image) {
            factory(\App\Slider::class)->create(['image' => $image]);
        }

        foreach (\App\Slider::cursor() as $slider) {
            foreach (languages() as $language) {
                factory(\App\SliderDescription::class)->create(
                    [
                        'slider_id' => $slider->id,
                        'language_id' => $language->id
                    ]
                );
            }
        }
    }
}
