<?php

use Illuminate\Database\Seeder;

class ProjectSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $images = [
            'assets/web/images/proj-1.png',
            'assets/web/images/proj-2.png',
            'assets/web/images/proj-3.png',
        ];

        foreach ($images as $image) {
            factory(\App\Project::class)->create(['image' => $image]);
        }


        foreach (languages() as $language) {
            foreach (\App\Project::cursor() as $project) {
                factory(\App\ProjectDescription::class)->create([
                    'project_id' => $project->id,
                    'language_id' => $language->id,
                ]);
            }
        }
    }
}
