<?php

use Illuminate\Database\Seeder;

class PageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {


        factory(\App\Page::class)->create([
            'images' => [
                'assets/web/images/icons/serv-1.svg',
                'assets/web/images/icons/serv-2.svg',
                'assets/web/images/icons/serv-3.svg',
                'assets/web/images/icons/serv-4.svg',
                'assets/web/images/icons/serv-5.svg',
            ],
            'meta' => [
                'numbers' => [
                    '400',
                    '+1000',
                    '450',
                    '7/24',
                    '12',
                ],
            ]
        ]);
        foreach (languages() as $language) {
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Our numbers',
                'title' => [
                    'حافلات التشغيل (Operating Buses)',
                    'سائق الباص (Bus Drivers)',
                    'محطات الحافلات (Bus Stops)',
                    'خدمة (Service)',
                    'خطوط الحافلات (Bus Routes)',
                ],
                'page_id' => 1,
                'language_id' => $language->id,
            ]);
        } // أرقامنا

        factory(\App\Page::class)->create([
            'meta' => [
                'years' => [
                    '2018',
                    '2019',
                    '2020',
                    '2021',
                    '2022',
                ],
            ]
        ]);
        foreach (languages() as $language) {
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Our journey',
                'description' => [
                    'Modern Bus Company is Formed',
                    'Bus Depot construction begins',
                    'Company reaches 100 employees',
                    'Bus Depot construction is completed',
                    'Operational Bus Services commence on 6 routes.
- 200 operational and support personnel.
- 600 qualified bus drivers, rising to 1,100 by the end of the year.',
                ],
                'page_id' => 2,
                'language_id' => $language->id,
            ]);
        } // رحلتنا

        factory(\App\Page::class)->create([
            'images' => [
                'assets/web/images/down-1.svg',
                'assets/web/images/logo3.svg',
            ]
        ]);
        foreach (languages() as $language) {
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Upload application',
                'title' => 'SMART APPS & TICKETS.',
                'description' => 'For bus schedules, timetable, online ticket bookings, and other information, we have a range of resources.',
                'page_id' => 3,
                'language_id' => $language->id,
            ]);
        } // تحميل التطبيق

        factory(\App\Page::class)->create([
            'image' => 'assets/web/images/logo3.svg',
        ]);
        foreach (languages() as $language) {
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Contact us',
                'description' => 'For general enquiries about Modern Bus Company, you can contact us on:',
                'page_id' => 4,
                'language_id' => $language->id,
            ]);
        } // تواصل معنا

        factory(\App\Page::class)->create([
            'images' => [
                'assets/web/images/contact-1.svg',
                'assets/web/images/icons/career.svg',
            ]
        ]);
        foreach (languages() as $language) {
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Our Careers.',
                'title' => 'Our Careers.',
                'description' => [
                    'Modern Bus Company is an equal opportunities employer, and we are always looking for exceptional and talented people to join our team. If you are interested in joining one of the most modern and innovative public bus transport companies in the Middle East, please send your CV or resume to',
                    'highlighting which area of the business you think you are most suited to.',
                ],
                'page_id' => 5,
                'language_id' => $language->id,
            ]);
        } // وظائفنا

        factory(\App\Page::class)->create([
            'image' => 'assets/web/images/header-1.png',
        ]);
        foreach (languages() as $language) {
            factory(\App\PageDescription::class)->create([
                'page_title' => 'About us (section 1)',
                'title' => 'ABOUT US.',
                'description' => 'Modern Bus Company (MBC), is a joint venture consortium led by Nesma Co. Ltd. It was established as the official contractor for the Makkah Public Bus Transport Program to become the first commercial public bus operator in the Kingdom of Saudi Arabia, with one of the most sophisticated, state-of-the-art, and technology-driven public bus transport systems in the world.',
                'page_id' => 6,
                'language_id' => $language->id,
            ]);
        } // من نحن السكشن 1

        factory(\App\Page::class)->create();
        foreach (languages() as $language) {
            factory(\App\PageDescription::class)->create([
                'page_title' => 'About us (section 2)',
                'description' => 'The company’s fleet of 400 buses operates a network of routes across Makkah City, one the busiest and most popular tourist destinations in the Middle East, and where millions of Muslims come every year to perform Hajj and Umrah. The network of 12 routes and 450 bus stops provides Makkah City’s citizens, residents, commuters and tourists with comfortable, affordable and convenient bus travel, 24 hours a day, seven days a week.',
                'page_id' => 7,
                'language_id' => $language->id,
            ]);
        } // من نحن السكشن 2

        factory(\App\Page::class)->create([
            'image' => 'assets/web/images/about-4.png',
        ]);
        foreach (languages() as $language) {
            factory(\App\PageDescription::class)->create([
                'page_title' => 'About us (section 3)',
                'description' => 'Through its partnerships and collaboration with internationally recognized public transport operators, such as TCC from Spain, MBC has established a transport system that brings the latest technology, systems, equipment and vehicles, together with invaluable knowledge, management experience, and industry know how. The result is a truly modern public bus transport system, managed by a highly experienced team, and run to international best practice standards.MBC is committed to providing a unique, high-quality passenger experience, and to establishing bus travel as the preferred form of transport for people from all walks of life, not just in Makkah City, but ultimately across the entire Kingdom, and beyond.',
                'page_id' => 8,
                'language_id' => $language->id,
            ]);
        } // من نحن السكشن 3

        factory(\App\Page::class)->create([
            'image' => 'assets/web/images/do_1.jpg',
        ]);
        foreach (languages() as $language) {
            factory(\App\PageDescription::class)->create([
                'page_title' => 'What we do (section 1)',
                'title' => 'OUR SERVICES.',
                'description' => 'MBC operates one of the most modern, sophisticated, technology-driven public bus transport systems in the world, providing a network of routes across Makkah City, one the busiest and most popular tourist destinations in the Middle East, and where millions of Muslims come every year to perform Hajj and Umrah. Our network of 12 routes and 450 bus stops, provides Makkah City’s citizens, residents, commuters and tourists with comfortable, affordable and convenient bus travel, 24 hours a day, 7 days a week.',
                'page_id' => 9,
                'language_id' => $language->id,
            ]);
        } // ماذا نفعل السشكن 1

        factory(\App\Page::class)->create([
            'image' => 'assets/web/images/do_1.jpg',
        ]);
        foreach (languages() as $language) {
            factory(\App\PageDescription::class)->create([
                'page_title' => 'What we do (section 2)',
                'title' => 'THE MBC FLEET',
                'description' => 'MBC benefits from having one of the most modern bus fleets in the world, and each one of our 400 buses offers passengers a unique travel experience, featuring:',
                'other_details' => [
                    'titles' => [
                        'The ultimate in comfort and safety',
                        'Air conditioned and thermostatically controlled interiors',
                        'Low-floored access for easy boarding and alighting',
                        'The ultimate in comfort and safety',
                        'Wheelchair and disabled access',
                        'Real-time on-board passenger information systems',
                        'Automated on-board information announcements for visually impaired passengers',
                        'Free Wi-Fi',
                        'On-board CCTV security system'
                    ]
                ],
                'page_id' => 10,
                'language_id' => $language->id,
            ]);
        } // ماذا نفعل السشكن 2

        factory(\App\Page::class)->create([
            'images' => [
                'assets/web/images/do_3.jpg',
                'assets/web/images/do_4.jpg',
            ]
        ]);
        foreach (languages() as $language) {
            factory(\App\PageDescription::class)->create([
                'page_title' => 'What we do (section 3)',
                'title' => 'BUS ROUTES & SCHEDULES.',
                'description' => 'MBC operates 12 different bus routes across the whole of Makkah City, with a total of 450 Bus Stops where passengers can board and alight. The services run seven days a week, 24 hours a day, with schedules set seasonally to meet expected demand.',
                'page_id' => 11,
                'language_id' => $language->id,
            ]);
        } // ماذا نفعل السشكن 3

        factory(\App\Page::class)->create([
            'images' => [
                'assets/web/images/icons/support-1.png',
                'assets/web/images/icons/support-2.png',
                'assets/web/images/icons/support-3.png',
                'assets/web/images/icons/support-4.png',
            ],
        ]);
        foreach (languages() as $language) {
            factory(\App\PageDescription::class)->create([
                'page_title' => 'What we do (section 4)',
                'title' => 'ONLINE CUSTOMER SUPPORT & SERVICES .',
                'description' => 'Our customer experience is supported by a range of online ticketing and information services, available through a dedicated passenger website and via IOS and Android mobile apps. Our online services include:',
                'other_details' => [
                    'titles' => [
                        'Ticketing',
                        'Journey Planning',
                        'Applications for Concession Cards & Discounts',
                        'Lost & Found Information'
                    ]
                ],
                'page_id' => 12,
                'language_id' => $language->id,
            ]);
        } // ماذا نفعل السشكن 4

        factory(\App\Page::class)->create([
            'image' => 'assets/web/images/do_5.jpg',
            'images' => [
                'assets/web/images/icons/support-1.png',
                'assets/web/images/icons/support-2.png',
                'assets/web/images/icons/support-2.png',
                'assets/web/images/icons/support-1.png',
                'assets/web/images/icons/support-4.png',
                'assets/web/images/icons/support-3.png',
                'assets/web/images/icons/support-2.png',
                'assets/web/images/icons/support-1.png',
            ]
        ]);
        foreach (languages() as $language) {
            factory(\App\PageDescription::class)->create([
                'page_title' => 'What we do (section 5)',
                'title' => 'OFFLINE CUSTOMER SUPPORT & SERVICES .',
                'description' => 'MBC also has a range of offline support services to enhance customer experience, including:',
                'other_details' => [
                    'titles' => [
                        '1,000 +',
                        '12',
                        '24/7',
                        'Park & Ride',
                        'Real Time',
                        'Network',
                        'Solar Powered',
                        'Found Office'
                    ],
                    'descriptions' => [
                        'Point of Sales for Bus Tickets',
                        'dedicated Service Centers',
                        'Customer Service Call Center',
                        'locations across Makkah City',
                        'Information Systems at all bus stops',
                        'of selected closed, air-conditioned bus stops',
                        'Bus Stops',
                        'Lost & Found Office'
                    ]
                ],
                'page_id' => 13,
                'language_id' => $language->id,
            ]);
        } // ماذا نفعل السشكن 5

        factory(\App\Page::class)->create([
            'image' => 'assets/web/images/do_6.png',
        ]);
        foreach (languages() as $language) {
            factory(\App\PageDescription::class)->create([
                'page_title' => 'What we do (section 6)',
                'title' => 'OPERATIONAL SUPPORT .',
                'description' => [
                    'titles' => [
                        'MBC BUS DEPOT',
                        'MBC OPERATIONAL CONTROL CENTER',
                        'MAINTENANCE &amp; REPAIR',
                        'DRIVER TRAINING SIMULATOR'
                    ],
                    'descriptions' => [
                        'Operating a fleet of 400 buses 24 hours a day, 7 days a week, requires highly specialized operational and management support and the nucleus of the MBC fleet’s operational support is its 100,000 sqm Bus Depot, which includes the Operational Control Center, Maintenance Facilities, and Fuel Stations. The support teams include:',
                        'The operational teams track and monitor all buses in real-time and can communicate directly with drivers using the on-board VOIP system. The teams can adjust service schedules and departures in real time, to maximize both service efficiency and customer experience, using data from the on-board Automated Passenger Counting Sensors.',
                        'MBC’s highly skilled maintenance teams operate 24/7, delivering planned and reactive servicing and maintenance to keep the bus fleet in optimum condition.',
                        'MBC’s bus drivers receive advanced training in the company’s state-of-the-art Driving Simulator which, like an aircraft simulator, allows instructors to put drivers through a number of driving experiences, including unexpected bad weather and vehicle failures.'
                    ],
                ],
                'other_details' => [
                    [
                        'titles' => [
                            '200 technical, operational, maintenance and management personnel',
                            '1,100 qualified bus drivers'
                        ]
                    ],
                ],
                'page_id' => 14,
                'language_id' => $language->id,
            ]);
        } // ماذا نفعل السشكن 6

        factory(\App\Page::class)->create([
            'image' => 'assets/web/images/drives-1.png',
        ]);
        foreach (languages() as $language) {
            factory(\App\PageDescription::class)->create([
                'page_title' => 'What drives us (section 1)',
                'title' => 'Our Vision.',
                'description' => '<ul>
                                    <li class="li">
                                        To be the Region’s Number One public bus transport operator.  
                                    </li>
                                    <li class="li">
                                        To be recognized as one of the world’s top bus operating companies in the public transport industry.
                                    </li>
                                    <li class="li">
                                        To be recognized as one of the leading bus operating companies in the global public transport sector.
                                    </li>
                                </ul>',
                'page_id' => 15,
                'language_id' => $language->id,
            ]);
        } // ما الذي يدفعنا السكشن 1

        factory(\App\Page::class)->create([
            'image' => 'assets/web/images/drives-2.png',
        ]);
        foreach (languages() as $language) {
            factory(\App\PageDescription::class)->create([
                'page_title' => 'What drives us (section 2)',
                'title' => 'Our Mission.',
                'description' => 'To provide modern, reliable, and accessible public transport services that establish bus transport as the most convenient, affordable, and environmentally friendly mode of transport in the Region.',
                'page_id' => 16,
                'language_id' => $language->id,
            ]);
        } // ما الذي يدفعنا السكشن 2

        factory(\App\Page::class)->create([
            'images' => [
                'assets/web/images/values-1.png',
                'assets/web/images/header-1.png',
                'assets/web/images/drives-1.png',
                'assets/web/images/about-1.png',
            ],
        ]);
        foreach (languages() as $language) {
            factory(\App\PageDescription::class)->create([
                'page_title' => 'What drives us (section 3)',
                'title' => 'Our Values.',
                'other_details' => [
                    'titles' => [
                        'Empathy',
                        'Environment',
                        'Inclusive',
                        'Excellence',
                    ],
                    'descriptions' => [
                        'We understand that our passengers come first, and we will always behave with compassion and respect.',
                        'We are committed to having a positive impact on the environment, by reducing traffic congestion, air and noise pollution, and fuel consumption.',
                        'We are an equal opportunities company that provides public transport for everybody.',
                        'Excellence guides everything we do.',

                    ],
                ],
                'page_id' => 17,
                'language_id' => $language->id,
            ]);
        } // ما الذي يدفعنا السكشن 3

        factory(\App\Page::class)->create([
            'image' => 'assets/web/images/impact_2.png',
        ]);
        foreach (languages() as $language) {
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Our impact (section 3)',
                'title' => 'MBC & THE ENVIRONMENT',
                'description' => 'MBC operates one of the most modern, sophisticated, technology-driven public bus transport systems in the world, providing a network of routes across Makkah City, one the busiest and most popular tourist destinations in the Middle East, and where millions of Muslims come every year to perform Hajj and Umrah. Our network of 12 routes and 450 bus stops, provides Makkah City’s citizens, residents, commuters and tourists with comfortable, affordable and convenient bus travel, 24 hours a day, 7 days a week.',
                'page_id' => 18,
                'language_id' => $language->id,
            ]);
        } // تأثيرنا السكشن 1

        factory(\App\Page::class)->create([
            'images' => [
                'assets/web/images/enviro-1.png',
                'assets/web/images/enviro-2.png',
                'assets/web/images/enviro-3.png',
                'assets/web/images/enviro-4.png',
                'assets/web/images/enviro-5.png',
            ],
        ]);
        foreach (languages() as $language) {
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Our impact  (section 3)',
                'title' => 'MBC & THE ENVIRONMENT .',
                'other_details' => [
                    'titles' => [
                        'The Pilgrim Experience Program',
                        'The Pilgrim Experience Program',
                        'The Pilgrim Experience Program',
                        'The Pilgrim Experience Program',
                        'The Pilgrim Experience Program',
                    ],
                    'descriptions' => [
                        'Saudi Vision 2030 is an ambitious vision for an ambitious nation and its Vision Realization Programs (VRPs) have been designed to translate the Vision into action. At MBC, we are actively supporting a number of the key VRPs, including:',
                        'Saudi Vision 2030 is an ambitious vision for an ambitious nation and its Vision Realization Programs (VRPs) have been designed to translate the Vision into action. At MBC, we are actively supporting a number of the key VRPs, including:',
                        'Saudi Vision 2030 is an ambitious vision for an ambitious nation and its Vision Realization Programs (VRPs) have been designed to translate the Vision into action. At MBC, we are actively supporting a number of the key VRPs, including:',
                        'Saudi Vision 2030 is an ambitious vision for an ambitious nation and its Vision Realization Programs (VRPs) have been designed to translate the Vision into action. At MBC, we are actively supporting a number of the key VRPs, including:',
                        'Saudi Vision 2030 is an ambitious vision for an ambitious nation and its Vision Realization Programs (VRPs) have been designed to translate the Vision into action. At MBC, we are actively supporting a number of the key VRPs, including:',
                    ],
                ],
                'page_id' => 18,
                'language_id' => $language->id,
            ]);
        } // تأثيرنا السكشن 2

        factory(\App\Page::class)->create([
            'images' => [
                'assets/web/images/logos/1.svg',
                'assets/web/images/logos/2.svg',
                'assets/web/images/logos/3.svg',
                'assets/web/images/logos/4.svg',
                'assets/web/images/logos/5.svg',
                'assets/web/images/logos/4.svg',
                'assets/web/images/company-1.svg',
                'assets/web/images/company-6.svg',
                'assets/web/images/company-7.svg',
                'assets/web/images/company-8.svg',
                'assets/web/images/company-9.svg',
                'assets/web/images/company-10.svg',
            ],
        ]);
        foreach (languages() as $language) {
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Our impact  (section 3)',
                'title' => 'MBC & OUR PARTNERS.',
                'description' => [
                    'The six members of the TNC Consortium (Modern Bus Company)',
                    'Some of our stakeholders and sub-contractors'
                ],
                'other_details' => [
                    'titles' => [
                        'Consultrans',
                        'Imathia',
                        'Imathia',
                        'Al-Maghrabi',
                        'TCC',
                        'Al-Maghrabi',
                        'Nesma Co. Ltd',
                        'Haji Husein Alireza Co. Ltd HHA (MAN)',
                        'Mobily',
                        'Najia Abdullatif Jameel Group (NajTech)',
                        'Simsoft',
                        'SABB Bank',
                        'TCC',
                    ],
                ],
                'page_id' => 20,
                'language_id' => $language->id,
            ]);
        } // تأثيرنا السكشن 3

        factory(\App\Page::class)->create([
            'image' => 'assets/web/images/about-2.png',
            'meta' => ['video_url' => 'https://www.youtube.com/watch?v=mkggXE5e2yk']
        ]);
        foreach (languages() as $language) {
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Our Story (section 1)',
                'title' => 'Our Story.',
                'description' => [
                    'MBC was established in 2018 as the official contractor for the Makkah Public Bus Transport Program, Phase 1, under the leadership of the Royal Commission of Makkah and the Holy Sites. The company is a joint venture consortium, comprising six companies, led by Nesma Co. Ltd, and including:',
                    'Delivering business solutions for the Transforming Public Transport in Saudi Arabia'
                ],
                'other_details' => [
                    'titles' => ['Watch the Video'],
                    'descriptions' => ['Sed do eiusmod tempor'],
                ],
                'page_id' => 21,
                'language_id' => $language->id,
            ]);
        } // قصتنا السكشن 1

        factory(\App\Page::class)->create();
        foreach (languages() as $language) {
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Our Story (section 3)',
                'other_details' => [
                    'titles' => [
                        'Nesma Co. Ltd',
                        'TCC',
                        'Consultrans',
                        'Imathia Arabia',
                        'Al-Shoula',
                        'Al-Maghrabi',
                    ],
                    'descriptions' => [
                        'The Consortium Leader',
                        'Public Transport Operator for Barcelonar',
                        'Spanish Partner',
                        'Saudi Arabian Partner',
                        'Saudi Arabian Partner',
                        'Saudi Arabian Partner',
                    ]
                ],
                'page_id' => 22,
                'language_id' => $language->id,
            ]);
        } // قصتنا السكشن 2



    }
}
