<?php

use Illuminate\Database\Seeder;

class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $categories = factory(\App\Category::class, 3)->create();

        foreach (languages() as $language) {
            foreach ($categories as $category) {
                factory(\App\CategoryDescription::class)->create([
                    'category_id' => $category->id,
                    'language_id' => $language->id,
                ]);
            }

        }
    }

}
