<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateArticleTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('articles', function (Blueprint $table) {
            $table->id();
            $table->date('news_date')->nullable();
            $table->string('image', 250)->nullable();
//            $table->unsignedBigInteger('category_id')->nullable();
//            $table->text('tags_ids')->nullable();
//            $table->string('video', 300)->nullable();
//            $table->enum('video_type', [1,2])->nullable()->comment('1-> Youtube video file, 2-> localfile');
//            $table->unsignedBigInteger('user_id')->index();
//            $table->bigInteger('visit_counts')->nullable();

//            $table->foreign('user_id')->references('id')->on('users');


            $table->softDeletes();
            $table->timestamps();

            // Set engine to InnoDB it's useful in join and constraint
            $table->engine = 'InnoDB';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('articles');
    }
}
