<?php

/** @var Factory $factory */

use App\Language;
use App\WebsiteCategory;
use App\WebsiteCategoryDescription;
use Faker\Generator as Faker;
use Illuminate\Database\Eloquent\Factory;

$factory->define(WebsiteCategoryDescription::class, function (Faker $faker) {
    return [
        'name' => $faker->sentence,
        'slug' => $faker->unique()->slug(1),
        'website_category_id' => factory(WebsiteCategory::class)->create()->id,
        'language_id' => Language::firstOrCreate(['local'=> getCurrentLocale(), 'name'=> \LaravelLocalization::getCurrentLocaleName()])->id,
    ];
});
