<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Slider extends Model
{
    use SoftDeletes;

    protected $fillable = ['button_url', 'image'];

    public static function withDescription($id = null)
    {
        $query = self::orderBy('sliders.id', 'DESC')
            ->join('slider_descriptions as sd', 'sd.slider_id', 'sliders.id')
            ->where('sd.language_id', currentLanguage()->id);

        if ($id){
            $query->where('sliders.id', $id);
        }

        $query->select([
            'sliders.id',
            'sliders.image',
            'sliders.button_url',
            'sd.first_title',
            'sd.second_title',
            'sd.button_title',
            'sd.description'
        ]);

        return $id ? $query->first() : $query->cursor();
    }
}
