<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;


/**
 * @property mixed id
 * @property mixed title
 * @property mixed message
 */
class NotificationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $local = getCurrentLocale();
        return [
            'id' => $this->id,
            'title' => $this->title[$local],
            'message' => $this->message[$local],
        ];
    }
}
