<?php

namespace App\Http\Middleware;

use App\User;
use Closure;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;

class ApiTokenMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {

        $token = $request->bearerToken() ?? $request->header('apiToken');
        if(!$token){
            return response()->json(['message' => __('main.you_must_logged')], 401);
        }

        $user = User::where('api_token', $token)->first();
        if(!$user){
            return response()->json(['message' => __('main.you_must_logged')], 401);
        }

        Auth::login($user);

        if ($request->header('local') && $user->lang != $request->header('local')) {
            // $user->lang = $request->header('local');
            // $user->save();
        }

        // dd($user->toArray());
        $request->user = $user;
        return $next($request);
    }
}
