<?php

namespace App\Http\Controllers\Web;

use App\Gallery;
use App\Http\Controllers\Controller;
use Illuminate\View\View;

class GalleryController extends Controller
{

    private $view = 'web.galleries.';
    /**
     * Show the application dashboard.
     * @return View
     */
    public function index(): View
    {
        $title = __('galleries.photos_videos_galleries');
        $photosGalleries = Gallery::withDescription('image_type')->toArray();
        $videosGalleries = Gallery::withDescription('video_type')->toArray();
        $photosGalleries = array_chunk($photosGalleries, 4);
        $videosGalleries = array_chunk($videosGalleries, 4);

        return view($this->view.'index', get_defined_vars());
    }

}
