<?php
namespace App\Helpers;

use Illuminate\Support\Facades\App;

/**
 * Class based Helper to send Notifications
 */
class NotificationHelper
{

    /**
     * Helper to send Notifications
     * @param $file
     * @param int $width
     * @param int $height
     * @return string
     */
    public static function sendNotification($data = '', $target = '') {
        //FCM API end-point
        $url = 'https://fcm.googleapis.com/fcm/send';
        //api_key available in Firebase Console -> Project Settings -> CLOUD MESSAGING -> Server key
        // $server_key = env('FIREBASE_SERVER_KEY');
        // dd($server_key, App::environment('FIREBASE_SENDER_ID'), );
//        $server_key = config('app.firebase_server_key');
        $env_server_key = env('FIREBASE_SERVER_KEY');
        $server_key = $env_server_key ?? 'AAAAkoUk7PQ:APA91bEgCRVGpZxBoUo-hFv0g6WuL_f09GiYRsKHS3bz5sZiPlm4OBAzdhvW26n4GQDbjyRx0CR0ieBTTkqEJSYh1pKjMeJ7V-5hYNrze1j2Yv_bhAJMAGrsVLw6gmz574SuyEsGnLiZ';
        // dd($server_key);
        $data['data'] = $data['notification'];
        $fields = array_merge($target, $data);
        $headers = array(
            'Content-Type:application/json',
            'Authorization:key=' . $server_key
        );
        //CURL request to route notification to FCM connection server (provided by Google)
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
        $result = curl_exec($ch);
        if ($result === FALSE) {
            die('Oops! FCM Send Error: ' . curl_error($ch));
        }
        curl_close($ch);
        return $result;
    }
}


